<?php
/**
* 2024 CodeEshop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
*
*  @author    CodeEshop <sales@codeeshop.com>
*  @copyright 2024 CodeEshop
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class WiserreviewAjaxModuleFrontController extends ModuleFrontController
{
    public $ajax = true;

    public function initContent()
    {
        parent::initContent();

        $type = Tools::getValue('type');
        $action = Tools::getValue('export_action');

        if($type == 'date-range') {
            $start = Tools::getValue('start_date');
            $end = Tools::getValue('end_date');
        } else {
            $duration = Tools::getValue('duration');
            $end = date('Y-m-d');
            $start = date('Y-m-d', strtotime('-'.$duration.' days'));
        }

        $csvfile = '';
        $order_data = [];
        $orders_formatted = [];
        $orders = Order::getOrdersIdByDate($start, $end);

        if($action == 'fetch-orders') {
            $result = [
                'success' => true,
                'result' => (string) count($orders),
            ];
    
            die(json_encode($result));
        }

        foreach ($orders as $id_order) {
            $order = new Order($id_order);
            $order_data = $this->module->getFormattedOrderData($order);
            $orders_formatted[] = $order_data;
            if($action == 'send-campaign') {
                $this->module->postOrderToWiser(json_encode($order_data));
            }
        }

        if($action == 'download-csv') {
            $csvfile = $this->createCsv($orders_formatted);
        }
        
        $result = [
            'success' => true,
            'result' => $csvfile,
            'message' => '',
        ];

        die(json_encode($result));
    }

    private function createCsv($orders) 
    {
        $filename = 'orders_'.uniqid().'.csv';

        $file = _PS_MODULE_DIR_ . 'wiserreview/views/exports/'.$filename;
        
        $relativePath = 'modules/wiserreview/views/exports/' . $filename;
        $webPath = Tools::getShopDomainSsl(true) . __PS_BASE_URI__ . $relativePath;

        if (!file_exists(dirname($file))) {
            mkdir(dirname($file), 0755, true);
        }
        
        $handle = fopen($file, 'w');

        // Header
        fputcsv($handle, ['First Name', 'Last Name', 'Phone', 'Email', 'Product Title', 'Product URL', 'Product Image URL', 'Product Id', 'Reviewer Image URL', 'Order Date']);
        
        foreach ($orders as $order) {
            $customer = $order['customer'];
            foreach ($order['line_items'] as $product) {
                fputcsv($handle, [
                    $customer['first_name'],
                    $customer['last_name'],
                    $customer['phone'],
                    $customer['email'],
                    $product['name'],
                    $product['pu'],
                    $product['piu'],
                    $product['id'],
                    NULL,
                    $order['cdt'],
                ]);    
            }
        }

        fclose($handle);

        return $webPath;
    }

}
