<form method="post" action="" class="defaultForm form-horizontal">
	<div class="panel">
		<div class="panel-heading">
			<i class="icon-cogs"></i> {l s="WiserReview Multistore Settings" mod="wiserreview"}
		</div>
		<div class="panel-body form-wrapper">
			<ul class="nav nav-tabs" id="shopTabs">
				{foreach from=$shops item=shop name=shoploop}
					<li class="nav-item">
						<a class="nav-link" id="tab-{$shop.id_shop}" data-bs-toggle="tab" href="#content-{$shop.id_shop}"data-active-shop-id="{$shop.id_shop}">
							{$shop.name}
						</a>
					</li>
				{/foreach}
			</ul>
			<div class="tab-content mt-3">
				{foreach from=$shops item=shop name=shoploop}
					<div class="tab-pane {if $smarty.foreach.shoploop.first}show{/if}" id="content-{$shop.id_shop}">
						<div class="form-wrapper">
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}LIVE_MODE_{$shop.id_shop}">{l s="Status {$shop.name}" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<span class="switch prestashop-switch fixed-width-lg">
										<input
											type="radio"
											name="{$prefix}LIVE_MODE_{$shop.id_shop}"
											id="{$prefix}LIVE_MODE_on_{$shop.id_shop}"
											value="1"
											{if $fields_value[$prefix|cat:'LIVE_MODE_'|cat:$shop.id_shop] == 1}checked="checked"{/if}
										/>
										<label for="{$prefix}LIVE_MODE_on_{$shop.id_shop}">{l s="Enabled" mod="wiserreview"}</label>

										<input
											type="radio"
											name="{$prefix}LIVE_MODE_{$shop.id_shop}"
											id="{$prefix}LIVE_MODE_off_{$shop.id_shop}"
											value="0"
											{if $fields_value[$prefix|cat:'LIVE_MODE_'|cat:$shop.id_shop] == 0}checked="checked"{/if}
										/>
										<label for="{$prefix}LIVE_MODE_off_{$shop.id_shop}">{l s="Disabled" mod="wiserreview"}</label>

										<a class="slide-button btn"></a>
									</span>

									<p class="help-block">{l s="Use this module in live mode" mod="wiserreview"}</p>
								</div>
							</div>
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}API_KEY_{$shop.id_shop}">{l s="API Key" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<input 
										type="text" 
										name="{$prefix}API_KEY_{$shop.id_shop}" class="form-control" 
										value="{$fields_value["`$prefix`API_KEY_`$shop.id_shop`"]}"
									/>
									<p class="help-block">
										{l s="Get your API key from" mod="wiserreview"}
										<a href="https://app.wiserreview.com/" target="_blank" class="">WiserReview account</a>
									</p>
								</div>
							</div>
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}PRODUCT_SECTION_{$shop.id_shop}">{l s="Star rating count at PDP" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<span class="switch prestashop-switch fixed-width-lg">
										<input
											type="radio"
											name="{$prefix}PRODUCT_SECTION_{$shop.id_shop}"
											id="{$prefix}PRODUCT_SECTION_on_{$shop.id_shop}"
											value="1"
											{if $fields_value[$prefix|cat:'PRODUCT_SECTION_'|cat:$shop.id_shop] == 1}checked="checked"{/if}
										/>
										<label for="{$prefix}PRODUCT_SECTION_on_{$shop.id_shop}">{l s="Enabled" mod="wiserreview"}</label>

										<input
											type="radio"
											name="{$prefix}PRODUCT_SECTION_{$shop.id_shop}"
											id="{$prefix}PRODUCT_SECTION_off_{$shop.id_shop}"
											value="0"
											{if $fields_value[$prefix|cat:'PRODUCT_SECTION_'|cat:$shop.id_shop] == 0}checked="checked"{/if}
										/>
										<label for="{$prefix}PRODUCT_SECTION_off_{$shop.id_shop}">{l s="Disabled" mod="wiserreview"}</label>

										<a class="slide-button btn"></a>
									</span>
									<p class="help-block">{l s="Product Star Rating count on product page" mod="wiserreview"}</p>
								</div>
							</div>
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}COLLECTION_SECTION_{$shop.id_shop}">{l s="Product Star Rating count at PLP" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<span class="switch prestashop-switch fixed-width-lg">
										<input
											type="radio"
											name="{$prefix}COLLECTION_SECTION_{$shop.id_shop}"
											id="{$prefix}COLLECTION_SECTION_on_{$shop.id_shop}"
											value="1"
											{if $fields_value[$prefix|cat:'COLLECTION_SECTION_'|cat:$shop.id_shop] == 1}checked="checked"{/if}
										/>
										<label for="{$prefix}COLLECTION_SECTION_on_{$shop.id_shop}">{l s="Enabled" mod="wiserreview"}</label>

										<input
											type="radio"
											name="{$prefix}COLLECTION_SECTION_{$shop.id_shop}"
											id="{$prefix}COLLECTION_SECTION_off_{$shop.id_shop}"
											value="0"
											{if $fields_value[$prefix|cat:'COLLECTION_SECTION_'|cat:$shop.id_shop] == 0}checked="checked"{/if}
										/>
										<label for="{$prefix}COLLECTION_SECTION_off_{$shop.id_shop}">{l s="Disabled" mod="wiserreview"}</label>

										<a class="slide-button btn"></a>
									</span>
									<p class="help-block">{l s="Product Star Rating count on collection page" mod="wiserreview"}</p>
								</div>
							</div>
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}PRODUCT_REVIEW_SECTION_{$shop.id_shop}">{l s="Product review section" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<span class="switch prestashop-switch fixed-width-lg">
										<input
											type="radio"
											name="{$prefix}PRODUCT_REVIEW_SECTION_{$shop.id_shop}"
											id="{$prefix}PRODUCT_REVIEW_SECTION_on_{$shop.id_shop}"
											value="1"
											{if $fields_value[$prefix|cat:'PRODUCT_REVIEW_SECTION_'|cat:$shop.id_shop] == 1}checked="checked"{/if}
										/>
										<label for="{$prefix}PRODUCT_REVIEW_SECTION_on_{$shop.id_shop}">{l s="Enabled" mod="wiserreview"}</label>

										<input
											type="radio"
											name="{$prefix}PRODUCT_REVIEW_SECTION_{$shop.id_shop}"
											id="{$prefix}PRODUCT_REVIEW_SECTION_off_{$shop.id_shop}"
											value="0"
											{if $fields_value[$prefix|cat:'PRODUCT_REVIEW_SECTION_'|cat:$shop.id_shop] == 0}checked="checked"{/if}
										/>
										<label for="{$prefix}PRODUCT_REVIEW_SECTION_off_{$shop.id_shop}">{l s="Disabled" mod="wiserreview"}</label>

										<a class="slide-button btn"></a>
									</span>
									<p class="help-block">{l s="Product Review section on product pages" mod="wiserreview"}</p>
								</div>
							</div>
							<div class="form-group">
								<label class="control-label col-lg-4" for="{$prefix}REVIEW_NUDGES_{$shop.id_shop}">{l s="Review nudges" mod="wiserreview"}</label>
								<div class="col-lg-4">
									<span class="switch prestashop-switch fixed-width-lg">
										<input
											type="radio"
											name="{$prefix}REVIEW_NUDGES_{$shop.id_shop}"
											id="{$prefix}REVIEW_NUDGES_on_{$shop.id_shop}"
											value="1"
											{if $fields_value[$prefix|cat:'REVIEW_NUDGES_'|cat:$shop.id_shop] == 1}checked="checked"{/if}
										/>
										<label for="{$prefix}REVIEW_NUDGES_on_{$shop.id_shop}">{l s="Enabled" mod="wiserreview"}</label>

										<input
											type="radio"
											name="{$prefix}REVIEW_NUDGES_{$shop.id_shop}"
											id="{$prefix}REVIEW_NUDGES_off_{$shop.id_shop}"
											value="0"
											{if $fields_value[$prefix|cat:'REVIEW_NUDGES_'|cat:$shop.id_shop] == 0}checked="checked"{/if}
										/>
										<label for="{$prefix}REVIEW_NUDGES_off_{$shop.id_shop}">{l s="Disabled" mod="wiserreview"}</label>

										<a class="slide-button btn"></a>
									</span>
									<p class="help-block">{l s="Review nudges on product pages" mod="wiserreview"}</p>
								</div>
							</div>
							<input type="hidden" name="{$prefix}WISER_REVIEW_TI_{$shop.id_shop}" value="" />
							<input type="hidden" name="{$prefix}WISER_AUTOMATION_ID_{$shop.id_shop}" value="" />
							<input type="hidden" name="{$prefix}WISER_HEADER_PXL_{$shop.id_shop}" value="" />
							<input type="hidden" name="{$prefix}WISER_CONTENT_NUDGE_{$shop.id_shop}" value="" />
							<input type="hidden" name="{$prefix}WISER_CONTENT_RATING_{$shop.id_shop}" value="" />
							<input type="hidden" name="{$prefix}WISER_CONTENT_REVIEW_{$shop.id_shop}" value="" />
						</div>
					</div>
				{/foreach} 
			</div>
		</div>
		<div class="panel-footer">
			<button type="submit" id="module_form_submit_btn" name="submitwiserreview" class="btn btn-default pull-right">
				<i class="process-icon-save"></i> 
				{l s="Save" mod="wiserreview"}
			</button>
		</div>
	</div>
	<input type="hidden" name="WISER_ACTIVE_SHOP" value="" />
</form>

<script>
	document.addEventListener("DOMContentLoaded", function () {
	    let hiddenInput = document.querySelector('input[name="WISER_ACTIVE_SHOP"]');

	    // Restore from localStorage
	    let savedShopId = localStorage.getItem("activeShopId");
	    if (savedShopId) {
	        let tabToActivate = document.querySelector('.nav-link[data-active-shop-id="' + savedShopId + '"]');
	        if (tabToActivate) {
	            tabToActivate.classList.add("active");
	            document.querySelector(tabToActivate.getAttribute("href")).classList.add("show");
	            if (hiddenInput) {
	                hiddenInput.value = savedShopId;
	                hiddenInput.setAttribute("value", savedShopId);
	            }
	        }
	    } else {
	        // If nothing saved yet, set from first active tab
	        let activeTab = document.querySelector('.nav-link.active');
	        if (activeTab && hiddenInput) {
	            hiddenInput.value = activeTab.getAttribute("data-active-shop-id");
	            hiddenInput.setAttribute("value", activeTab.getAttribute("data-active-shop-id"));
	        }
	    }

	    // Save on click
	    document.querySelectorAll('[data-bs-toggle="tab"]').forEach(function (tab) {
	        tab.addEventListener("click", function (e) {
	            e.preventDefault();
	            let shopId = this.getAttribute("data-active-shop-id");

	            // Switch tab
	            document.querySelectorAll(".tab-pane").forEach(el => el.classList.remove("show"));
	            document.querySelector(this.getAttribute("href")).classList.add("show");
	            document.querySelectorAll(".nav-link").forEach(el => el.classList.remove("active"));
	            this.classList.add("active");

	            // Update hidden input
	            if (hiddenInput) {
	                hiddenInput.value = shopId;
	                hiddenInput.setAttribute("value", shopId);
	            }

	            // Save to localStorage
	            localStorage.setItem("activeShopId", shopId);
	        });
	    });
	});
</script>

<style>
	.tab-content {
		border: 1px solid #e1e1e1;
	}
	.nav-link {
		color: #000!important;
	}
	.nav-link.active, .bootstrap .nav>li>a:focus, .bootstrap .nav>li>a:hover {
		background-color: #e1e1e1;
	}
</style>
