<div class="panel">
    <h3><i class="icon icon-cogs"></i> {l s='Collect Reviews from Past Customers' mod='wiserreview'}</h3>

    <div class="panel-content">
		<div id="loader">
			<div class="loading-text">{l s='Processing...' mod='wiserreview'}</div>
		</div>
		<div class="form-group">
			<button type="button" data-id="duration" class="btn btn-default option-btn active">
				{l s='By Duration' mod='wiserreview'}
			</button>
			<button type="button" data-id="date-range" class="btn btn-default option-btn"> 
				{l s='By Date Range' mod='wiserreview'}
			</button>
		</div>

		<div id="duration" class="form-duration form-group">
			<div class="row">
				<div class="col-lg-12">
					<label for="duration">{l s='Select Duration' mod='wiserreview'}</label>
					<select id="duration-input" name="duration-input" class="form-control">
						<option value="7">{l s='Last 7 days' mod='wiserreview'}</option>
						<option value="30">{l s='Last 30 days' mod='wiserreview'}</option>
						<option value="90">{l s='Last 3 months' mod='wiserreview'}</option>
						<option value="180">{l s='Last 6 months' mod='wiserreview'}</option>
						<option value="365">{l s='Last 1 Year' mod='wiserreview'}</option>
					</select>
				</div>
			</div>
		</div>

		<div id="date-range" class="form-duration form-group">
			<div class="row">
				<div class="col-lg-6">
					<label for="date_from">{l s='Start Date' mod='wiserreview'}</label>
					<input type="date" id="date_from" name="date_from" class="form-control" />
				</div>
				<div class="col-lg-6">
					<label for="date_from">{l s='End Date' mod='wiserreview'}</label>
					<input type="date" id="date_to" name="date_to" class="form-control" />
				</div>
			</div>
		</div>

		<div class="form-group">
			<label>{l s='Show Count' mod='wiserreview'}</label>
			<p><strong id="count"></strong> {l s='records found.' mod='wiserreview'}</p>
			<button 
				data-type="fetch-orders" 
				class="btn btn-info export-action" 
				{if $ex_status == 'disable'}disabled{/if}
			>
				{l s='Fetch Data' mod='wiserreview'}
			</button>
		</div>
    </div>

    <div class="panel-footer">
		<div class="text-right">
			<button 
				data-type="download-csv" class="btn btn-default export-action" 
				{if $ex_status == 'disable'}disabled{/if}
			> 
				<i class="icon-download"></i> {l s='Download as CSV' mod='wiserreview'}
			</button>
			<button 
				data-type="send-campaign" class="btn btn-success export-action" 
				{if $ex_status == 'disable'}disabled{/if}
			>
				{l s='Send to Automated Campaign' mod='wiserreview'}
			</button>
		</div>
    </div>
</div>

<script>
$(document).ready(function () {
	$('.option-btn').click(function() {
		$('.option-btn').removeClass('active')
		$(this).addClass('active')
		let option = $(this).data('id')
		$('.form-duration').hide()
		$('#'+option).show()
	})

    $('.export-action').on('click', function (e) {
        e.preventDefault();
        console.log('{$ajax_admin_link}', '')
		let action_type = $(this).data('type')

		let $btn = $(this);
		$btn.attr('disabled', true); 
		$('#loader').show()

		let type = $('.option-btn.active').data('id')
		let _data;
		if(type == 'date-range') {
			_data = {
				start: $('#date_from').val(),
				end: $('#date_to').val()
			}
		} else {
			_data = {
				duration: $('#duration-input').val()
			}
		}
		
        $.ajax({
            url: '{$ajax_admin_link}',
            type: 'POST',
            dataType: 'json',
            data: {
				export_action: action_type,
				type: type,
				..._data
			},
            success: function (response) {
				console.log(response, 'response--wiser');
				$btn.attr('disabled', false);
				$('#loader').hide()
				// 
				if(response.result && action_type == 'download-csv') {
					const link = document.createElement('a');
					link.href = response.result;
					link.download = 'order.csv';
					document.body.appendChild(link);
					link.click();
					document.body.removeChild(link);
				} else if(response.result && action_type == 'fetch-orders') {
					$('#count').text(response.result)
				} else {
					alert('Data has been sent to wiser review.');
				}
            },
            error: function () {
                $btn.attr('disabled', false);
				$('#loader').hide()
            }
        });
    });
});
</script>

<style>
	.active {
		background-color: #25b9d7;
	}
  	#date-range {
    	display: none;
  	}
  	.panel-content {
    	width: fit-content;
    	margin: auto;
  	}
	#loader {
		display: none;
		position: absolute;
		top: 0;
		left: 0;
		background-color: rgba(0,0,0,0.8);
		width: 100%;
		height: 100%;
		z-index: 9;
	}
	.loading-text {
		display: flex;
		align-items: center;
		justify-content: center;
		height: 100%;
		font-size: 32px;
		color: #fff!important;
		font-weight: 800!important;
	}
</style>